/*  _ _ _
 * | (_) |__ ___ ___ _ __  __ _   SEPA library  www.libsepa.com
 * | | | '_ (_-</ -_) '_ \/ _` |  Copyright (c) 2013-2014 Keppler IT GmbH.
 * |_|_|_.__/__/\___| .__/\__,_|____________________________________________
 *                  |_|
 * $Id: SEPA.xs 155 2014-01-06 17:42:48Z kk $
 */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include <sepa.h>

typedef sepa_t * SEPA;
typedef int bool_t;

__attribute__((destructor))
static void destroy_libsepa() {
  sepa_cleanup();
}

MODULE = SEPA		PACKAGE = SEPA		PREFIX = sepa_

# PROTOTYPES: ENABLE

BOOT:
{
#define IV_CONST(X) newCONSTSUB(stash, #X, newSViv(X))
	HV *stash = gv_stashpv("SEPA", TRUE);
	IV_CONST(SEPA_MSGTYPE_CTI);
	IV_CONST(SEPA_MSGTYPE_DDI);
	IV_CONST(SEPA_DDTYPE_CORE);
	IV_CONST(SEPA_DDTYPE_COR1);
	IV_CONST(SEPA_DDTYPE_B2B);
	IV_CONST(SEPA_INIT_LICUSER);
	IV_CONST(SEPA_INIT_LICCODE);
	IV_CONST(SEPA_INIT_RULEBOOK);
	IV_CONST(SEPA_SCL_SCT);
	IV_CONST(SEPA_SCL_SDD);
	IV_CONST(SEPA_SCL_COR1);
	IV_CONST(SEPA_SCL_B2B);
}

# __________________________________________________________________________
sepa_status_t
sepa_init(option, value)
	sepa_init_t option
	const char *value

# __________________________________________________________________________
char*
sepa_IBAN_convert(country, account, bankid)
	const char *country
	const char *account
	const char *bankid
PPCODE:
	char iban[SEPA_IBAN_MAXLENGTH+1];
	if (sepa_iban_convert(country, account, bankid, (char*)&iban) == SEPA_LOOKUP_OK) {
		EXTEND(SP, 1);
		PUSHs(sv_2mortal(newSVpv(iban, 0)));
	}

# __________________________________________________________________________
char*
sepa_IBAN_getBIC(iban)
	const char *iban
PPCODE:
	char bic[SEPA_BIC_LENGTH+1];
	if (sepa_iban_getBIC(iban, (char*)&bic) == SEPA_LOOKUP_OK) {
		EXTEND(SP, 1);
		PUSHs(sv_2mortal(newSVpv(bic, 0)));
	}

# __________________________________________________________________________
bool_t
sepa_IBAN_check(iban)
	const char *iban
CODE:
	RETVAL = sepa_iban_check(iban) > 0 ? 1 : 0;
OUTPUT:
	RETVAL

# __________________________________________________________________________
char*
sepa_BIC_getBankName(bic)
	const char *bic
PPCODE:
	sepa_bankinfo_t *bank;
	if (sepa_bic_getBank(bic, &bank) == SEPA_OK) {
		EXTEND(SP, 1);
		PUSHs(sv_2mortal(newSVpv(bank->name, 0)));
		free(bank);
	}

# __________________________________________________________________________
int
sepa_BIC_getBankFlags(bic)
	const char *bic
PPCODE:
	sepa_bankinfo_t *bank;
	if (sepa_bic_getBank(bic, &bank) == SEPA_OK) {
		EXTEND(SP, 1);
		PUSHs(sv_2mortal(newSViv(bank->flags)));
		free(bank);
	}

# __________________________________________________________________________
SEPA
sepa_new(class, msgtype)
	char *class
	sepa_msgtype_t msgtype
CODE:
	RETVAL = sepa_new(msgtype);
	if (RETVAL == NULL) {
		croak("Out of memory for %s", class);
	}
OUTPUT:
	RETVAL

# __________________________________________________________________________
void
sepa_DESTROY(sepa)
	SEPA sepa
CODE:
	sepa_free(sepa);

# __________________________________________________________________________
sepa_status_t
sepa_setIBAN(sepa, iban)
	SEPA sepa
	const char *iban
POSTCALL:
	if (RETVAL != SEPA_OK) {
		croak("%s", sepa_getError(sepa));
	}

# __________________________________________________________________________
sepa_status_t
sepa_setBIC(sepa, bic)
	SEPA sepa
	const char *bic
POSTCALL:
	if (RETVAL != SEPA_OK) {
		croak("%s", sepa_getError(sepa));
	}

# __________________________________________________________________________
sepa_status_t
sepa_setName(sepa, name)
	SEPA sepa
	const char *name
POSTCALL:
	if (RETVAL != SEPA_OK) {
		croak("%s", sepa_getError(sepa));
	}

# __________________________________________________________________________
sepa_status_t
sepa_setCreditorIdentifier(sepa, ci)
	SEPA sepa
	const char *ci
POSTCALL:
	if (RETVAL != SEPA_OK) {
		croak("%s", sepa_getError(sepa));
	}

# __________________________________________________________________________
sepa_status_t
sepa_setDate(sepa, date)
	SEPA sepa
	const char *date
POSTCALL:
	if (RETVAL != SEPA_OK) {
		croak("%s", sepa_getError(sepa));
	}

# __________________________________________________________________________
sepa_status_t
sepa_setDDType(sepa, ddtype)
	SEPA sepa
	sepa_ddtype_t ddtype
POSTCALL:
	if (RETVAL != SEPA_OK) {
		croak("%s", sepa_getError(sepa));
	}

# __________________________________________________________________________
sepa_status_t
sepa_add(sepa, hash)
	SEPA sepa
	HV * hash
PREINIT:
	sepa_status_t st;
	HE *elem;
	char *key;
	I32 keylen;
	SV *value;
	int i, count;
CODE:
	count = HvKEYS(hash);
	hv_iterinit(hash);
	sepa_keyvalue_t kv[count+1];
	for (i=0; i<count; i++) {
		value = hv_iternextsv(hash, &key, &keylen);
		kv[i].key = key;
		kv[i].value = SvPV_nolen(value);
	}
	kv[i].key = NULL;
	kv[i].value = NULL;
	RETVAL = sepa_add(sepa, kv);
OUTPUT:
	RETVAL
POSTCALL:
	if (RETVAL != SEPA_OK) {
		croak("Can't add transaction: %s", sepa_getError(sepa));
	}

# __________________________________________________________________________
const char *
sepa_toXML(sepa)
	SEPA sepa
PPCODE:
	char *xml = sepa_toXML(sepa);
	if (xml == NULL) {
		croak("%s", sepa_getError(sepa));
	}
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSVpv(xml, 0)));
	free(xml);

# __________________________________________________________________________
