<?php
#  _ _ _
# | (_) |__ ___ ___ _ __  __ _   SEPA library  www.libsepa.com
# | | | '_ (_-</ -_) '_ \/ _` |  Copyright (c) 2013 Keppler IT GmbH.
# |_|_|_.__/__/\___| .__/\__,_|_____________________________________________
#                  |_|
# php/example.php
# Example for libsepa usage with PHP
# $Id: example.php 144 2013-12-18 20:43:55Z kk $

# Test: php -d "extension=modules/sepa.so" example.php

$iban  = SEPA::IBAN_convert("DE", "4020000002", "30120764");
$bic   = SEPA::IBAN_getBIC($iban);
$valid = SEPA::IBAN_check($iban);

print "IBAN=$iban, BIC=$bic, VALID=$valid\n";

$sepa = new SEPA(SEPA_MSGTYPE_DDI);
$sepa->setIBAN("DE87200500001234567890");
$sepa->setBIC("BANKDEFFXXX");
$sepa->setName("Mustermann u. Co. KG");
$sepa->setCreditorIdentifier("DE98ZZZ09999999999");
$sepa->setDDType(SEPA_DDTYPE_B2B);
$tx = array(
    'seq'    => 'FRST',
    'id'     => 'R2017742-1',
    'name'   => 'Carl Customer',
    'mref'   => '(MandateReference)',
    'mdate'  => '2013-09-24',
    'amount' => 123.45,
    'iban'   => 'DE87200500001234567890',
    'bic'    => 'BANKDEZZXXX',
    'ref'    => 'Invoice R2017742 from 17/10/2013',
    );
$sepa->add($tx);
$xml = $sepa->toXML();
echo $xml;
?>