#  _ _ _
# | (_) |__ ___ ___ _ __  __ _   SEPA library  www.libsepa.com
# | | | '_ (_-</ -_) '_ \/ _` |  Copyright (c) 2013-2014 Keppler IT GmbH.
# |_|_|_.__/__/\___| .__/\__,_|_____________________________________________
#                  |_|
# perl/t/SEPA.t
# $Id: SEPA.t 163 2014-01-07 21:47:22Z kk $

# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl SEPA.t'

#########################

use Test::More tests => 11;
BEGIN { use_ok('SEPA') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

use SEPA;

# convert to IBAN
my ($iban, $bic, $name, $flags);
$iban = SEPA::IBAN_convert("DE", "4020000002", "30120764");
ok($iban eq 'DE95360201864020000002', 'IBAN conversion successful');

$bic = SEPA::IBAN_getBIC($iban);
ok($bic eq 'HYVEDEMM360', 'BIC conversion successful');

$iban = SEPA::IBAN_convert("DE", "4030000000", "30120764");
ok($iban eq 'DE22380200904030000000', 'IBAN conversion successful');

$bic = SEPA::IBAN_getBIC($iban);
ok($bic eq 'HYVEDEMM402', 'BIC conversion successful');

$name = SEPA::BIC_getBankName("BYLADEM1ERH");
ok($name eq 'STADT- UND KREISSPARKASSE ERLANGEN', 'SCL bank name lookup successful');

$flags = SEPA::BIC_getBankFlags("BYLADEM1ERH");
ok($flags == 15, 'SCL bank flags lookup successful');

# create SEPA object
my $sepa = new SEPA(SEPA_MSGTYPE_DDI);
ok(defined($sepa), 'got SEPA object');

# check IBANs
ok(SEPA::IBAN_check('DE22380200904030000000'), 'IBAN check (ok)');
ok(!SEPA::IBAN_check('DE22380200904030000001'), 'IBAN check (wrong)');

$sepa->setIBAN("DE87200500001234567890");
$sepa->setBIC("BANKDEFFXXX");
$sepa->setName("Mustermann u. Co. KG");
$sepa->setCreditorIdentifier("DE98ZZZ09999999999");
$sepa->setDDType(SEPA_DDTYPE_B2B);
my $tx = {
    'seq'    => 'FRST',
    'id'     => 'R2017742-1',
    'name'   => 'Carl Customer',
    'mref'   => '(MandateReference)',
    'mdate'  => '2013-09-24',
    'amount' => 123.45,
    'iban'   => 'DE87200500001234567890',
    'bic'    => 'BANKDEZZXXX',
    'ref'    => 'Invoice R2017742 from 17/10/2013',
    };
$sepa->add($tx);

# get XML
my $xml = $sepa->toXML();
# print STDERR $xml;

# destroy object
undef($sepa);
ok(!defined($sepa), 'SEPA object destroyed');

# <EOF>_____________________________________________________________________
